<?php

namespace Drupal\commerce_imoje;

use Symfony\Component\HttpFoundation\Request;

/**
 * Provides a handler for IPN requests from imoje.
 */
interface IPNHandlerInterface {

  /**
   * Processes an incoming IPN request.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request.
   * @param string $service_key
   *   The service key.
   * @param string $payment_gateway_id
   *   The payment gateway ID.
   *
   * @return mixed
   *   The request data array.
   *
   * @throws \Symfony\Component\HttpKernel\Exception\HttpException
   */
  public function process(Request $request, string $service_key, string $payment_gateway_id);

}
