<?php

namespace Drupal\commerce_imoje;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\commerce_payment\Entity\PaymentGatewayInterface;
use Drupal\commerce_payment\Entity\PaymentInterface;
use Drupal\commerce_price\Price;

/**
 * Provides a gateway methods for imoje.
 */
interface ImojeGatewayInterface {

  /**
   * Calls the imoje API.
   *
   * @param \Drupal\commerce_payment\Entity\PaymentGatewayInterface $commerce_payment_gateway
   *   The payment gateway.
   * @param string $api_url
   *   The API URL.
   * @param array $parameters
   *   The parameters.
   * @param string $method
   *   The HTTP method.
   *
   * @return array
   *   The API response.
   */
  public function callApi(PaymentGatewayInterface $commerce_payment_gateway, string $api_url, array $parameters = [], string $method = 'POST'): array;

  /**
   * Creates a BLIK transaction.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $commerce_order
   *   The order.
   * @param \Drupal\commerce_payment\Entity\PaymentGatewayInterface $commerce_payment_gateway
   *   The payment gateway.
   * @param string $blik_code
   *   The BLIK code.
   * @param string $ip_address
   *   The IP address.
   *
   * @return array
   *   The API response.
   */
  public function createBlikTransaction(OrderInterface $commerce_order, PaymentGatewayInterface $commerce_payment_gateway, string $blik_code, string $ip_address): array;

  /**
   * Gets the transaction status.
   *
   * @param \Drupal\commerce_payment\Entity\PaymentGatewayInterface $commerce_payment_gateway
   *   The payment gateway.
   * @param string $transaction_id
   *   The transaction ID.
   *
   * @return string
   *   The transaction status.
   */
  public function getTransactionStatus(PaymentGatewayInterface $commerce_payment_gateway, string $transaction_id): string;

  /**
   * Refunds a transaction.
   *
   * @param \Drupal\commerce_payment\Entity\PaymentInterface $payment
   *   The payment.
   * @param \Drupal\commerce_price\Price|null $amount
   *   The amount to refund.
   *
   * @return array
   *   The API response.
   */
  public function refundTransaction(PaymentInterface $payment, ?Price $amount = NULL): array;

}
