# Commerce Ingenico

Module provides _**[Ingenico ePayments](http://payment-services.ingenico.com/)**_ (aka _Ogone_) integration for the _**[Drupal Commerce](https://www.drupal.org/project/commerce)**_ framework.

## Features

 - Module provides 2 payment gateways:
   - _**[Ingenico DirectLink](https://payment-services.ingenico.com/int/en/ogone/support/guides/integration%20guides/directlink)**_ (on-site) - allows customers to enter their payment details directly on the merchant page without being redirected off-site,
   - _**[Ingenico e-Commerce](https://payment-services.ingenico.com/int/en/ogone/support/guides/integration%20guides/e-commerce)**_ (off-site) - hosted payment method that redirects customers off-site and returns them to the merchant page after a successful payment is made.

 - Both payment gateways support _Authorize and capture_ and _Authorize only_ transaction modes, as selected on Commerce's _Checkout flow_ configuration page. The _Authorize only_ transaction mode allows merchants to capture a transaction at a later time, which can be useful for avoiding refunds.

 - Both gateways support _3-D Secure_ credit card authentication when available.

   _e-Commerce_ does the authentication by default, without any additional configuration required (if only the [credit card being used supports it](https://payment-services.ingenico.com/int/en/ogone/support/guides/integration%20guides/directlink-3-d/3-d-transaction-flow-via-directlink#comments)), while in case of [_DirectLink_ _3-D Secure_](https://payment-services.ingenico.com/int/en/ogone/support/guides/integration%20guides/directlink-3-d) needs to be enabled first on the payment gateway configuration page.

   Note that to use _3-D Secure_ authentication with _DirectLink_, the _e-Commerce_ payment gateway needs to be defined as well, as when using _3-D Secure_ the payments initiated in _DirectLink_ mode will end in _e-Commerce_ mode.

 - Both payment gateways support the following [maintenance operations](https://payment-services.ingenico.com/int/en/ogone/support/guides/integration%20guides/directlink/maintenance):
   - authorization capture,
   - authorization void,
   - authorization renewal,
   - captured payment refund.

 - _DirectLink_ gateway supports Ingenico's _[Alias Gateway](https://payment-services.ingenico.com/int/en/ogone/support/guides/integration%20guides/alias-gateway)_, which allows reusing credit cards for future payments without re-entering their details each time.

   No sensitive credit card information is stored locally - instead only the credit card alias generated by the _Alias Gateway_ after the first payment is stored and used for all future payments.

   Currently it is not possible to create and use credit card aliases with _e-Commerce_ gateway, as it is not supported by _Drupal Commerce_ yet. See relevant d.o. issue _[Allow offsite payment gateways to create and use payment methods](https://www.drupal.org/node/2838380)_ for more information.

 - _e-Commerce_ gateway provides multilingual support, with any off-site pages (including _3-D Secure_) being rendered in the language selected by the merchant in the gateway configuration.

## Known issues

 - It is not yet possible to create and use credit card aliases with off-site e-Commerce gateway, as it is not supported by Drupal Commerce yet. See relevant d.o. issue [Allow offsite payment gateways to create and use payment methods](https://www.drupal.org/node/2838380) for more information.

 - When adding a new payment for orders created from the admin UI using a credit card that supports 3-D Secure, the return from the 3-D Secure pages fails. There is a [pull request](https://github.com/drupalcommerce/commerce/pull/601) waiting to be merged into Drupal Commerce that will fix the issue.

## Installation

### Configure Ingenico

 - Log in with your Ingenico merchant account to the [test or prod environment](https://payment-services.ingenico.com/int/en/login) (depending which one you want to configure)

 - Make sure your test account is [properly configured and activated](https://payment-services.ingenico.com/int/en/ogone/support/guides/user%20guides/test-account-creation/configure-account)

 - In _**Configuration > Account > Your options**_ you should have at least the following options activated:

   - _Fraud detection module (FDM)_
   - _D3D (Direct Link 3D)_
   - _DirectLink (new payments)_
   - _Partial maintenance_
   - _Alias Manager_
   - _Refunds_
   - _User Manager up to 5 users_

   You might need to contact Ingenico's <a href="mailto:support@ogone.com">Customer Care</a> team to activate some of them.

 - In _**Configuration > Users**_: create a special API user that will be used for the  API calls by Drupal - click on the _New user_ button, enter required details, select _Admin_ profile and check the _Special user for API (no access to admin)_ checkbox.

 - In _**Configuration > Technical information**_:

   - Tab _**Global transaction parameters**_:
     - _Default operation code_ setting doesn't matter, as it will depend on the Commerce's _Transaction mode_ value
     - set _Processing for individual transactions_ to _Online but switch to offline when the online acquiring system is unavailable._
     - set _Default ECI value_ to _7 - E-commerce with SSL encryption_

   - Tab _**Global security parameters**_:
     - set _Hash algorithm_ to _SHA-512_ (most secure)
     - set _Character encoding_ to _UTF-8_

   - Tab _**Data and origin verification**_:
     - set _URL of the merchant page containing the payment form that will call the page: orderstandard.asp_ to your site's base URL
     - set _SHA-IN pass phrase_ twice - both for _e-Commerce & Alias Gateway_ as well as for _Ogone DirectLink and Ogone Batch (Automatic)_ - both keys have to be alphanumeric only and both must have the same value
     - optionally set _IP address_ to that of your server
     
   - Tab _**Transaction feedback**_:
     - In _HTTP redirection in the browser_ section:
       - no need to set _Accepturl_, _Declineurl_, _Exceptionurl_ or _Cancelurl_, as they will be added automatically to each API request
       - enable _I would like to receive transaction feedback parameters on the redirection URLs_ checkbox
       - disable _I would like Ingenico e-Commerce Solutions to display a short text to the customer on the secure payment page if a redirection to my website is detected immediately after the payment process_ checkbox
     - In _Direct HTTP server-to-server request_ section:
       - set _Timing of the request_ to _Online but switch to a deferred request when the online requests fail_
       - set both _URLs of the merchant's post-payment page_ to `https://yoursite.com/payment/notify/<PARAMVAR>`
       - set _Request method_ to _GET_
     - In _Security for request parameters_ section:
       - set _SHA-OUT pass phrase_

   - Tab _**Transaction e-mails**_ (optionally):
     - fill in your email address
     - set _Receive transaction confirmation e-mails_ to _Yes, for all transaction submission modes_
     - set _Receive e-mails in the event of offline transaction status changes_ to _Yes, for each offline status change (payment, cancellation, etc.)_

### Install and configure the module

 - Use [Composer](https://getcomposer.org/) to get the module with all its dependencies:

   ```
   commerce require drupal/commerce_ingenico
   ```

   Alternatively download the module manually together with [marlon-ogone](https://github.com/marlon-be/marlon-ogone) and [mobiledetectlib](https://packagist.org/packages/mobiledetect/mobiledetectlib) libraries.

 - Add payment gateways at _**Administration > Commerce > Configuration > Payment gateways**_. The settings for both gateways are pretty much the same and should reflect your _Ingenico_ account settings.

 - You might also want to change / verify the _Transaction mode_ setting to be either _Authorize and capture_ or _Authorize only_ - at _**Administration > Commerce > Configuration > Checkout flows**_.

 - Make sure that your site is visible from the Internet, as otherwise you will not be able to receive asynchronous server-to-server notifications, which are required to update to payment transaction status.

   For testing the integration on local installations you might use a service like [Pagekite](https://pagekite.net/) to make your local site visible from the Internet.

## Testing

### Test credit card numbers

 Brand                             |   Type  |   Card number    |      Expiry date       | 3DS Password
-----------------------------------|---------|------------------|------------------------|--------------
 Visa*                             | unknown | 4111111111111111 | Any date in the future |
 Visa                              | credit  | 4000024329596391 | Any date in the future |
 Visa                              | debit   | 4000068558002134 | Any date in the future |
 MasterCard                        | credit  | 5399999999999999 | Any date in the future |
 MasterCard                        | debit   | 5101169573112521 | Any date in the future |
 MasterCard                        | unknown | 5100867871071536 | Any date in the future |
 Visa with 3-D Secure              |         | 4000000000000002 | Any date in the future |    11111
 MasterCard with 3-D Secure        |         | 5300000000000006 | Any date in the future |    11111
 American Express with 3-D Secure  |         | 371449635311004  | Any date in the future |    11111

*) Although this is a generally accepted test card, if you have configured not to accept "unknown" card types, tests with this card number will be declined.
