<?php

declare(strict_types=1);

namespace Drupal\commerce_irpaymentpack\Banks;

/**
 * Exception class for Zibal gateway errors.
 */
class ZibalException extends \Exception {

  /**
   * The error code from Zibal API.
   *
   * @var int|null
   */
  protected ?int $zibalErrorCode;

  /**
   * Additional context data.
   *
   * @var array
   */
  protected array $context;

  /**
   * Constructor.
   *
   * @param string $message
   *   The exception message.
   * @param int|null $zibal_error_code
   *   The Zibal API error code.
   * @param array $context
   *   Additional context data.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous throwable.
   */
  public function __construct(
    string $message = '',
    ?int $zibal_error_code = NULL,
    array $context = [],
    int $code = 0,
    ?\Throwable $previous = NULL
  ) {
    parent::__construct($message, $code, $previous);
    $this->zibalErrorCode = $zibal_error_code;
    $this->context = $context;
  }

  /**
   * Gets the Zibal error code.
   *
   * @return int|null
   *   The Zibal error code or NULL if not available.
   */
  public function getZibalErrorCode(): ?int {
    return $this->zibalErrorCode;
  }

  /**
   * Gets the context data.
   *
   * @return array
   *   The context data.
   */
  public function getContext(): array {
    return $this->context;
  }

}