Commerce Klarna
===============

CONTENTS OF THIS FILE
---------------------
* Introduction
* Requirements
* Configuration

INTRODUCTION
------------
This module integrates Drupal Commerce with Klarna
including the Klarna Payments [1], Express Checkout [2], On-site Messaging [3] and the Merchant Card Service [4].

1. https://docs.klarna.com/payments/web-payments/before-you-start/what-is-klarna-payments/
2. https://docs.klarna.com/conversion-boosters/express-checkout/before-you-start/
3. https://docs.klarna.com/conversion-boosters/on-site-messaging/before-you-start/
4. https://docs.klarna.com/merchant-card-service/merchant-card-service/overview-of-merchant-card-service/

REQUIREMENTS
------------
This module should be added to your codebase via Composer

`composer require "drupal/commerce_klarna"`

You must also have an Klarna account or developer access to the account
you intend to configure for your integration.
You can sign up for one [here](https://www.klarna.com/international/enterprise/).

There are no other requirements than [Commerce Core 3](https://www.drupal.org/project/commerce)

FEATURES
------------
* Onsite checkout integration for Klarna Payments and Merchant Card Service.
* Express checkout integration for Klarna Payments on the cart page.
* On-site messaging integration on the product and cart page.
* Order management interface for Klarna Payments and Merchant Card Service.
* Configurable style options for Klarna button.
* No third party dependencies.
* Commerce shipping integration.
* Event subscribers for enriching order payload.
* Base Merchant Card Service integration.
* Available payment methods: Pay now, Pay later, Pay over time.

CONFIGURATION
-------------
Once you've installed the module, you must navigate to the Drupal Commerce
payment gateway configuration screen to define a payment gateway configuration.
This will require providing depending on which integration you use API key, username, client token
and configuring the mode (Live vs. Test).

Note: It's important that you select a proper Klarna region for your account.

## Klarna Payments configuration
Enter your Klarna account credentials and select the integration mode. Configure on-site messaging,
express checkout and style options.

## Merchant Card Service configuration
This option is only available to you for use if Klarna enabled Merchant Card Service for your account.
It allows you to use Klarna-issued cards for payments.
The integration is done to the point where you can make the final implementation based on your specific needs.
Please consult with Klarna support for more information.

## Express checkout and collecting shipping address
If you want to enable express checkout on the cart page, you must enable under Klarna Payments gateway
configuration the option "Enable express checkout."

If you want to collect shipping address on the cart page, you must enable under Klarna Payments gateway
configuration the option "Collect shipping information through Klarna."
And enable the submodule `commerce_klarna_shipping`.

Without a submodule being enabled, the checkout will fail.

CUSTOMIZATION
-------------
For most of the actions this module provides an event subscriber that can be used to alter the behavior.
See all events at `\Drupal\commerce_klarna\Event\KlarnaEvents`

Supported events are such as creating and updating payment sessions (order payload),
express checkout and shipment-specific events. And in the case of Merchant Card Service,
the card promise event
