<?php

namespace Drupal\commerce_klarna\Event;

use Drupal\commerce\EventBase;
use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\profile\Entity\ProfileInterface;

/**
 * Defines the express checkout shipment call.
 *
 * @see \Drupal\commerce_klarna\Event\KlarnaEvents
 */
class KlarnaShipmentsEvent extends EventBase {

  /**
   * List of shipments.
   */
  protected array $shipments = [];

  /**
   * Constructs a new KlarnaShipmentsEvent object.
   */
  public function __construct(protected OrderInterface $order, protected ProfileInterface $profile) {}

  /**
   * Gets the order.
   */
  public function getOrder(): OrderInterface {
    return $this->order;
  }

  /**
   * Gets the shipping profile.
   */
  public function getShippingProfile(): ProfileInterface {
    return $this->profile;
  }

  /**
   * Set created shipments.
   */
  public function setShipments(array $shipments): static {
    $this->shipments = $shipments;
    return $this;
  }

  /**
   * Get shipments.
   */
  public function getShipments(): array {
    return $this->shipments;
  }

}
