<?php

namespace Drupal\commerce_klarna\Event;

/**
 * Defines events for the Commerce Klarna module.
 */
final class KlarnaEvents {

  /**
   * Name of the event fired when calling Klarna for creating a payment session.
   *
   * @Event
   *
   * @see \Drupal\commerce_klarna\Event\KlarnaRequestEvent
   */
  const CREATE_PAYMENT_SESSION = 'commerce_klarna.create_payment_session';

  /**
   * Name of the event fired when calling Klarna for creating a payment session.
   *
   * @Event
   *
   * @see \Drupal\commerce_klarna\Event\KlarnaRequestEvent
   */
  const UPDATE_PAYMENT_SESSION = 'commerce_klarna.update_payment_session';

  /**
   * Name of the event fired when calling Klarna for creating an order.
   *
   * @Event
   *
   * @see \Drupal\commerce_klarna\Event\KlarnaRequestEvent
   */
  const CREATE_ORDER_REQUEST = 'commerce_klarna.create_order_request';

  /**
   * Name of the event fired when calling Klarna for express checkout.
   *
   * @Event
   *
   * @see \Drupal\commerce_klarna\Event\KlarnaRequestEvent
   */
  const CREATE_EXPRESS_ORDER_REQUEST = 'commerce_klarna.create_express_order_request';

  /**
   * Name of the event fired before the payment capture request is made.
   *
   * @Event
   *
   * @see \Drupal\commerce_klarna\Event\KlarnaRequestEvent
   */
  const PAYMENT_CAPTURE_REQUEST = 'commerce_klarna.payment_capture_request';

  /**
   * Name of the event fired before the payment refund request is made.
   *
   * @Event
   *
   * @see \Drupal\commerce_klarna\Event\KlarnaRequestEvent
   */
  const PAYMENT_REFUND_REQUEST = 'commerce_klarna.payment_refund_request';

  /**
   * Name of the event fired before the card create promise request is made.
   *
   * @Event
   *
   * @see \Drupal\commerce_klarna\Event\KlarnaRequestEvent
   */
  const CREATE_CARD_PROMISE = 'commerce_klarna.create_card_promise';

  /**
   * The event fired when shipping profile is created on express checkout.
   *
   * @Event
   *
   * @see \Drupal\commerce_klarna\Event\KlarnaShipmentsEvent
   */
  const EXPRESS_CHECKOUT_SHIPMENTS = 'commerce_klarna.express_checkout_shipments';

}
