<?php

namespace Drupal\commerce_klarna\Event;

use Drupal\commerce\EventBase;
use Drupal\commerce_order\Entity\OrderInterface;

/**
 * Defines the order request event.
 *
 * @see \Drupal\commerce_klarna\Event\KlarnaEvents
 */
class KlarnaRequestEvent extends EventBase {

  /**
   * Constructs a new OrderRequestEvent object.
   */
  public function __construct(protected OrderInterface $order, protected array $payload) {}

  /**
   * Gets the order.
   */
  public function getOrder(): OrderInterface {
    return $this->order;
  }

  /**
   * Gets the API request data.
   */
  public function getPayload(): array {
    return $this->payload;
  }

  /**
   * Sets the API request data.
   */
  public function setPayload(array $payload): KlarnaRequestEvent {
    $this->payload = $payload;
    return $this;
  }

}
