<?php

declare(strict_types=1);

namespace Drupal\commerce_klarna\Exception;

/**
 * Handling Klarna specific errors.
 */
final class KlarnaException extends \Exception {

  /**
   * List of Klarna error responses.
   */
  protected array $klarnaErrorResponse = [];

  /**
   * Constructor.
   */
  public function __construct(
    string $message = '',
    int $code = 0,
    array $klarna_error_response = [],
    ?\Throwable $previousException = NULL,
  ) {
    parent::__construct($message, $code, $previousException);
    $this->klarnaErrorResponse = $klarna_error_response;
  }

  /**
   * Get Klarna error code.
   */
  public function getKlarnaCode(): string {
    return $this->klarnaErrorResponse['error_code'] ?? (string) $this->code;
  }

  /**
   * Get Klarna error message.
   */
  public function getKlarnaMessage(): string {
    return $this->klarnaErrorResponse['error_messages'][0] ?? $this->message;
  }

  /**
   * Format message with code and error.
   */
  public function getKlarnaError(): string {
    return sprintf('Error code: %s. Error message: %s', $this->getKlarnaCode(), $this->getKlarnaMessage());
  }

  /**
   * Get Klarna unique identifier for an error.
   */
  public function getCorelationId(): ?string {
    return $this->klarnaErrorResponse['corelation_id'] ?? NULL;
  }

}
