<?php

namespace Drupal\commerce_klarna\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_payment\Entity\PaymentGatewayInterface;

/**
 * The Klarna MCS definition.
 */
interface KlarnaMerchantCardInterface {

  /**
   * Get external card acquirer as Drupal payment gateway entity.
   */
  public function getCardAcquirer(): ?PaymentGatewayInterface;

  /**
   * Get private key.
   */
  public function getPrivateKey(): ?string;

  /**
   * Decrypt card data.
   *
   * @return false|string
   *   String if success decryption.
   *
   * @see https://docs.klarna.com/merchant-card-service/merchant-card-service/overview-of-merchant-card-service/#decryption
   */
  public function decryptCard(array $card_values): false|string;

  /**
   * Get unique identifier for the public key to be used for encryption.
   */
  public function getKeyId(): string;

}
