<?php

namespace Drupal\commerce_klarna\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OnsitePaymentGatewayInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\SupportsAuthorizationsInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\SupportsNotificationsInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\SupportsRefundsInterface;

/**
 * Klarna payments interface definition.
 */
interface KlarnaPaymentsInterface extends OnsitePaymentGatewayInterface, SupportsAuthorizationsInterface, SupportsRefundsInterface, SupportsNotificationsInterface {
  public const KLARNA_PAYMENTS_SESSION = 'session';

  public const KLARNA_PAYMENTS_FINALIZE = 'finalize';

  public const KLARNA_PAYMENTS_CHECKOUT_ONE_STEP = 'one-step';
  public const KLARNA_PAYMENTS_CHECKOUT_MULTI_STEP = 'multi-step';

  /**
   * Get Klarna username (API username).
   */
  public function getUsername(): string;

  /**
   * Get Klarna password (API key).
   */
  public function getPassword(): string;

  /**
   * Get Klarna client token.
   */
  public function getClientToken(): string;

  /**
   * Get Klarna buy button style.
   */
  public function getStyle(): array;

  /**
   * Generate API base url based of region.
   */
  public function getApiUrl(): string;

  /**
   * Determine if express checkout is enabled on cart.
   */
  public function expressCheckoutEnabled(): bool;

  /**
   * Determine if shipping address needs to be collected in express checkout.
   */
  public function collectShippingAddress(): bool;

}
