<?php

namespace Drupal\commerce_klarna\Plugin\Commerce\PaymentMethodType;

use Drupal\commerce_klarna\KlarnaManagerInterface;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\PaymentMethodTypeBase;
use Drupal\entity\BundleFieldDefinition;

/**
 * Provides the Klarna payment method type.
 *
 * @CommercePaymentMethodType(
 *   id = "klarna",
 *   label = @Translation("Klarna"),
 * )
 */
class Klarna extends PaymentMethodTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    return $payment_method->get('klarna_payment_type')->value ? sprintf('Klarna %s', KlarnaManagerInterface::KLARNA_PAYMENT_METHODS[$payment_method->get('klarna_payment_type')->value]) : 'Klarna';
  }

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    $fields['klarna_payment_type'] = BundleFieldDefinition::create('list_string')
      ->setLabel($this->t('Klarna payment method type'))
      ->setDescription($this->t('The Klarna payment type.'))
      ->setRequired(TRUE)
      ->setSetting('allowed_values_function', KlarnaManagerInterface::KLARNA_PAYMENT_METHODS);

    $fields['klarna_installments'] = BundleFieldDefinition::create('integer')
      ->setLabel($this->t('Number of installments'))
      ->setSetting('size', 'tiny');

    $fields['klarna_days'] = BundleFieldDefinition::create('integer')
      ->setLabel($this->t('Number of days'))
      ->setSetting('size', 'small');

    return $fields;
  }

}
