<?php

namespace Drupal\commerce_klarna\Plugin\Commerce\PaymentMethodType;

use Drupal\commerce_klarna\KlarnaManagerInterface;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\PaymentMethodTypeBase;
use Drupal\entity\BundleFieldDefinition;

/**
 * Provides the Klarna virtual cards method type.
 *
 * @CommercePaymentMethodType(
 *   id = "klarna_merchant_card",
 *   label = @Translation("Klarna"),
 * )
 */
class KlarnaMerchantCard extends PaymentMethodTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    return $payment_method->get('klarna_payment_type')->value ? sprintf('Klarna %s', KlarnaManagerInterface::KLARNA_PAYMENT_METHODS[$payment_method->get('klarna_payment_type')->value]) : 'Klarna';
  }

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    $fields['klarna_payment_type'] = BundleFieldDefinition::create('list_string')
      ->setLabel($this->t('Klarna payment method type'))
      ->setDescription($this->t('The Klarna payment type.'))
      ->setRequired(TRUE)
      ->setSetting('allowed_values_function', KlarnaManagerInterface::KLARNA_PAYMENT_METHODS);

    $fields['klarna_promise_id'] = BundleFieldDefinition::create('string')
      ->setLabel($this->t('Card promise'))
      ->setDescription($this->t('The Klarna card promise identifier.'))
      ->setRequired(TRUE);

    $fields['klarna_settlement_id'] = BundleFieldDefinition::create('string')
      ->setLabel($this->t('Klarna settlement id'))
      ->setDescription($this->t('The Klarna settlement identifier.'))
      ->setRequired(TRUE);

    $fields['klarna_cards'] = BundleFieldDefinition::create('integer')
      ->setLabel($this->t('Number of virtual cards being created'))
      ->setSetting('size', 'tiny');

    return $fields;
  }

}
