<?php

namespace Drupal\commerce_klarna_checkout\Plugin\Commerce\CheckoutPane;

use Drupal\commerce_checkout\Plugin\Commerce\CheckoutFlow\CheckoutFlowInterface;
use Drupal\commerce_checkout\Plugin\Commerce\CheckoutPane\CheckoutPaneBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Markup;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides the Klarna checkout confirmation snippet.
 *
 * @CommerceCheckoutPane(
 *   id = "commerce_klarna_checkout_confirmation",
 *   label = @Translation("Klarna Confirmation message"),
 *   default_step = "complete",
 * )
 */
class KlarnaCheckoutConfirmation extends CheckoutPaneBase {

  /**
   * The Klarna manager factory.
   *
   * @var \Drupal\commerce_klarna_checkout\KlarnaManagerFactoryInterface
   */
  protected $klarnaManagerFactory;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition, ?CheckoutFlowInterface $checkout_flow = NULL) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition, $checkout_flow);
    $instance->klarnaManagerFactory = $container->get('commerce_klarna_checkout.manager_factory');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildPaneForm(array $pane_form, FormStateInterface $form_state, array &$complete_form) {
    try {
      /** @var \Drupal\commerce_payment\Entity\PaymentGatewayInterface $payment_gateway */
      $payment_gateway = $this->order->payment_gateway->entity;
      /** @var \Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OffsitePaymentGatewayInterface $payment_gateway_plugin */
      $payment_gateway_plugin = $payment_gateway->getPlugin();
      $klarna_manager = $this->klarnaManagerFactory->get($payment_gateway_plugin->getConfiguration());
      $klarna_order = $klarna_manager->getOrder($this->order);

      $pane_form['klarna_completion'] = [
        '#markup' => Markup::create($klarna_order['html_snippet']),
      ];
      return $pane_form;
    }
    catch (\Exception $exception) {
      return [];
    }
  }

  /**
   * {@inheritdoc}
   */
  public function isVisible() {
    if (!$this->order->hasField('payment_gateway') || $this->order->payment_gateway->isEmpty()) {
      return FALSE;
    }
    /** @var \Drupal\commerce_payment\Entity\PaymentGatewayInterface $payment_gateway */
    $payment_gateway = $this->order->payment_gateway->entity;
    return $payment_gateway && $payment_gateway->getPluginId() == 'klarna_checkout';
  }

}
