(function ($, Drupal, drupalSettings, cookies, navigator, screen) {
  Drupal.methodCheck = {}

  Drupal.methodCheck.methods = ['credit_card'];

  Drupal.methodCheck.updateUI = function(){
    if (Drupal.methodCheck.methods.includes('apple_pay')) {
      $(".radio.payment-method--commerce-mangopay-dpi-apple-pay").show();
    }
  }

  Drupal.behaviors.methodCheck = {
    attach: function (context, settings) {
      // If Apple Pay session enabled, please allow Apple Pay method
      $('[data-drupal-selector="edit-payment-information-payment-method"]:not(".js-processed"), [data-drupal-selector="edit-payment-option"]:not(".js-processed")').addClass("js-processed").each(function() {
        if (window.ApplePaySession) {
          var merchantIdentifier = drupalSettings.commerceMangopay.applePayMerchantID;

          var promise = ApplePaySession.canMakePaymentsWithActiveCard(merchantIdentifier);
          promise.then(function (canMakePayments) {
            if (canMakePayments) {
              Drupal.methodCheck.methods.push('apple_pay');
              Drupal.methodCheck.updateUI();
            }
          });
        }

        Drupal.methodCheck.updateUI();
      })
    }
  };

})(jQuery, Drupal, drupalSettings, window.Cookies, navigator, screen);
