(function ($, Drupal, drupalSettings, cookies, navigator, screen) {
  Drupal.commerceMangopayGooglePay = {}

  Drupal.behaviors.commerceMangopayGooglePay = {
    attach: function (context, settings) {
      if (!window.google || !window.google.payments) {
        return;
      }

      const mangoPaySettings = drupalSettings.commerceMangopay;
      Drupal.commerceMangopayGooglePay.paymentClient = new google.payments.api.PaymentsClient({environment: mangoPaySettings.mode === 'sandbox' ? 'TEST' : 'PRODUCTION'});

      const submitButton = $('button#edit-actions-next');
      submitButton.hide()
      const form = submitButton.parents('form').first();

      if (!$('.mangopay-dpi-google-pay-form', form).length) {
        submitButton.show();
        $('#gpay-button-online-api-id').remove();
      }

      $('.mangopay-dpi-google-pay-form:not(".js-processed")', context).addClass('js-processed').each(function () {
        Drupal.commerceMangopayGooglePay.clearErrors(form);
        submitButton.off('click');
        submitButton.removeClass('js-processed');

        const language = window.location.pathname.split('/')[1];

        // Use Google-provided button or a simple button element
        let button = Drupal.commerceMangopayGooglePay.paymentClient.createButton({
          buttonType: 'pay',
          buttonRadius: 4,
          buttonSizeMode: 'fill',
          buttonLocale: language,
          onClick: () => Drupal.commerceMangopayGooglePay.onPayButtonClick(form, mangoPaySettings),
          allowedPaymentMethods: mangoPaySettings.googlePaySettings.allowedAuthMethods
        });

        submitButton.before(button);
      });
    }
  };

  // Main handler for pay button click
  Drupal.commerceMangopayGooglePay.onPayButtonClick = function (form, mangoPaySettings) {
    Drupal.commerceMangopayGooglePay.clearErrors();

    if (!Drupal.commerceMangopayGooglePay.validateRequired(form)) {
      $('html, body').animate({scrollTop: 0}, 200);
      return;
    }

    const googlePaySettings = mangoPaySettings.googlePaySettings;
    const paymentDataRequest = {
      apiVersion: 2,
      apiVersionMinor: 0,
      allowedPaymentMethods: [{
        type: 'CARD',
        parameters: {
          allowedAuthMethods: googlePaySettings.allowedAuthMethods,
          allowedCardNetworks: googlePaySettings.allowedCardNetworks,
        },
        tokenizationSpecification: {
          type: 'PAYMENT_GATEWAY',
          parameters: {
            gateway: 'whenthen',
            gatewayMerchantId: mangoPaySettings.clientId,
          }
        }
      }],
      merchantInfo: {
        merchantId: googlePaySettings.merchantId,
        merchantName: googlePaySettings.merchantName
      },
      transactionInfo: {
        totalPriceStatus: 'FINAL',
        totalPrice: Number(mangoPaySettings.amount).toFixed(2),
        currencyCode: mangoPaySettings.currencyCode,
        countryCode: $('select.country', form).val()
      }
    };

    // Drop the cookie with client fingerprint.
    // This data is used during /payins/card/direct to
    // allow MANGOPAY to conduct risk assessment for 3DSv2 purposes.
    cookies.set('commerce_mangopay_dpi_client', JSON.stringify({
      userAgent: navigator.userAgent,
      javaScriptEnabled: true,
      javaEnabled: navigator.javaEnabled(),
      language: navigator.language || navigator.userLanguage,
      timezoneOffset: new Date().getTimezoneOffset().toString(),
      screenWidth: screen.width,
      screenHeight: screen.height,
      colorDepth: screen.colorDepth
    }));

    Drupal.commerceMangopayGooglePay.paymentClient.loadPaymentData(paymentDataRequest).then(function (paymentData) {
      const token = paymentData.paymentMethodData.tokenizationData.token;

      $.ajax({
        method: 'POST',
        url: '/commerce-mangopay-dpi/preregister-google-pay/' + drupalSettings.commerceMangopay.paymentGatewayId,
        data: {
          billing_details: Drupal.commerceMangopayGooglePay.getBillingInformationInput(),
        },
      })
        .done(function (response) {
          $('input.mangopay-dpi-token-data', form).val(token);
          $('input.mangopay-dpi-user-id', form).val(response.userId);
          $('input.mangopay-dpi-wallet-id', form).val(response.walletId);

          form.submit();
        })
        .fail(function (error) {
          console.error("Error pre-registering the user data in MANGOPAY", error);
          Drupal.commerceMangopayGooglePay.setError(form, null, Drupal.t('An unexpected error occurred while processing your payment. Please confirm the details you entered are correct or try a different card. If the problem persists, please contact us.'));
          $('html, body').animate({scrollTop: 0}, 200);
        });
    });
  };

  // --- error helpers (same as your Apple Pay implementation) ---
  Drupal.commerceMangopayGooglePay.setError = function (form, formField, error) {
    if (formField) {
      const parentElement = formField.parents('.js-form-item').first();
      parentElement.addClass('error').addClass('has-error');
    }

    if (error) {
      $('.js-messages', form).show();
      $('.js-messages ul', form).append($('<li/>', {text: error}));
    }
  };

  Drupal.commerceMangopayGooglePay.clearErrors = function (form) {
    $('.js-form-item.has-error', form).each(function () {
      $(this).removeClass('has-error').removeClass('error');
    });

    $('.js-messages', form).hide();
    $('.js-messages ul', form).empty();
  };

  Drupal.commerceMangopayGooglePay.validateRequired = function (form) {
    let hasErrors = false;
    $('input[required], select[required]', form).each(function () {
      if (!$(this).val()) {
        Drupal.commerceMangopayGooglePay.setError(form, $(this));
        hasErrors = true;
      }
    });

    if (hasErrors) {
      Drupal.commerceMangopayGooglePay.setError(form, null, Drupal.t('Please fill required fields'));
    }

    return !hasErrors;
  };

  Drupal.commerceMangopayGooglePay.getBillingInformationInput = function (form) {
    return {
      currency_code: drupalSettings.commerceMangopay.currencyCode,
      firstName: $('input.given-name', form).val(),
      lastName: $('input.family-name', form).val(),
      address: {
        addressLine1: $('input.address-line1', form).val(),
        addressLine2: $('input.address-line2', form).val(),
        postalCode: $('input.postal-code', form).val(),
        city: $('input.locality', form).val(),
        region: $('select.administrative-area', form).val(),
        country: $('select.country', form).val(),
      },
      email: drupalSettings.commerceMangopay.email ? drupalSettings.commerceMangopay.email : $('input[data-drupal-selector="edit-contact-information-email"]', form).val()
    };
  };
})(jQuery, Drupal, drupalSettings, window.Cookies, navigator, screen);
