(function ($, Drupal, drupalSettings, cookies, navigator, screen) {
  Drupal.methodCheck = {}

  Drupal.methodCheck.methods = ['credit_card'];

  Drupal.methodCheck.updateUI = function(){
    if (Drupal.methodCheck.methods.includes('apple_pay')) {
      $(".radio.payment-method--commerce-mangopay-dpi-apple-pay").show();
    }

    if (Drupal.methodCheck.methods.includes('google_pay')) {
      $(".form-type-radio.payment-method--commerce-mangopay-dpi-google-pay").show();
    }
  }

  Drupal.behaviors.methodCheck = {
    attach: function (context, settings) {
      // If Apple Pay session enabled, please allow Apple Pay method
      $('[data-drupal-selector="edit-payment-information-payment-method"]:not(".js-processed"), [data-drupal-selector="edit-payment-option"]:not(".js-processed")').addClass("js-processed").each(function() {
        if (window.ApplePaySession) {
          const merchantIdentifier = drupalSettings.commerceMangopay.applePayMerchantID;

          const promise = ApplePaySession.canMakePaymentsWithActiveCard(merchantIdentifier);
          promise.then(function (canMakePayments) {
            if (canMakePayments) {
              Drupal.methodCheck.methods.push('apple_pay');
              Drupal.methodCheck.updateUI();
            }
          });
        }

        // Google Pay availability check.
        try {
          const googlePaySettings = drupalSettings.commerceMangopay.googlePaySettings;

          if (window.google && google.payments && google.payments.api) {
            const paymentsClient = new google.payments.api.PaymentsClient({ environment: drupalSettings.commerceMangopay.mode === 'sandbox' ? 'TEST' : 'PRODUCTION' });
            const isReadyToPayRequest = {
              apiVersion: 2,
              apiVersionMinor: 0,
              allowedPaymentMethods: [{
                type: 'CARD',
                parameters: {
                  allowedAuthMethods: googlePaySettings.allowedAuthMethods,
                  allowedCardNetworks: googlePaySettings.allowedCardNetworks,
                }
              }]
            };

            paymentsClient.isReadyToPay(isReadyToPayRequest).then(function(response) {
              if (response.result) {
                Drupal.methodCheck.methods.push('google_pay');
                Drupal.methodCheck.updateUI();
              }
            }).catch(function(){ /* noop */ });
          }
        } catch (e) {
          console.log(e)
        }

        Drupal.methodCheck.updateUI();
      })
    }
  };

})(jQuery, Drupal, drupalSettings, window.Cookies, navigator, screen);
