<?php

namespace Drupal\commerce_mangopay_dpi\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OnsitePaymentGatewayInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\SupportsNotificationsInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\SupportsRefundsInterface;
use Drupal\commerce_price\Price;
use MangoPay\Billing;
use MangoPay\BrowserInfo;
use MangoPay\PayIn;

/**
 * Provides the interface for the commerce_mangopay payment gateway.
 */
interface MangopayInterface extends OnsitePaymentGatewayInterface, SupportsRefundsInterface, SupportsNotificationsInterface {

  /**
   * @return \MangoPay\MangoPayApi
   */
  public function getApi();

  /**
   * Return tag for use with this payment gateway.
   * All resources created in MANGOPAY will use this tag.
   *
   * @return mixed
   */
  public function getTag();

  /**
   * Return Apple Pay merchant id
   *
   * @return mixed
   */
  public function getApplePayMerchantId();

  /**
   * Return Apple Pay merchant id certificate location
   *
   * @return mixed
   */
  public function getApplePayMerchantIdCertPath();

  /**
   * Return Apple Pay merchant id key location
   *
   * @return mixed
   */
  public function getApplePayMerchantIdKeyPath();

  /**
   * Return Apple Pay merchant id validated domain
   *
   * @return mixed
   */
  public function getApplePayMerchantIdDomain();

  /**
   * @param $first_name
   * @param $last_name
   * @param $email
   * @param $country
   * @param $address_line1
   * @param $address_line2
   * @param $city
   * @param $postal_code
   * @param string $region
   * @param string $tag
   * @return mixed
   */
  public function createNaturalUser($first_name, $last_name, $email,$country, $address_line1 = '', $address_line2 = '', $city = '', $postal_code = '', $region = '', $tag = '');

  /**
   *
   * @param [type] $first_name
   * @param [type] $last_name
   * @param [type] $email
   * @param [type] $country
   * @param string $address_line1
   * @param string $address_line2
   * @param string $city
   * @param string $postal_code
   * @param string $region
   * @param string $tag
   * @return mixed
   */
  public function resolveNaturalUser($first_name, $last_name, $email, $country, $address_line1 = '', $address_line2 = '', $city = '', $postal_code = '', $region = '', $tag ='', $user = NULL);

  /**
   * @param $user_id
   * @return mixed
   */
  public function getUser($user_id);

  /**
   * @param $mangopay_api
   * @param $user_id
   * @param $currency_code
   * @param $description
   * @param string $tag
   * @return mixed
   */
  public function createWallet($user_id, $currency_code, $description, $tag = '');

  /**
   * @param $user_id
   * @return mixed
   */
  public function getWallets($user_id);

  /**
   * @param $wallet_id
   * @return mixed
   */
  public function getWallet($wallet_id);

  /**
   * @param [type] $user_id
   * @param [type] $currency_code
   * @param string $tag
   * @return mixed
   */
  public function resolveWallet($user_id, $currency_code, $tag = '');

  /**
   * @param $mangopay_api
   * @param $user_id
   * @param $currency_code
   * @param $card_type
   * @param string $tag
   * @return mixed
   */
  public function createCardRegistration($user_id, $currency_code, $card_type, $tag = '');

  /**
   * @param $user_id
   * @param $wallet_id
   * @param $card_id
   * @param $amount
   * @param $currency_code
   * @param $ip_address
   * @param $browser_info
   * @param $secure_mode_return_url
   * @param string $secure_mode
   * @param string $statement_descriptor
   * @return mixed
   */
  public function createDirectPayIn($user_id, $wallet_id, $card_id, $amount, $currency_code, $ip_address, \MangoPay\BrowserInfo $browser_info, $secure_mode_return_url, $secure_mode = 'DEFAULT', $statement_descriptor = '');

  /**
   * @param [type] $pay_in_id
   * @param Price $refund_amount
   * @return mixed
   */
  public function createRefund($pay_in_id, Price $refund_amount);

  /**
   * @param $card_id
   * @return mixed
   */
  public function deregisterCard($card_id);

  /**
   * @param [type] $user_id
   * @param [type] $wallet_id
   * @param [type] $amount
   * @param [type] $currency_code
   * @param [type] $transaction_id
   * @param [type] $network
   * @param [type] $token_data
   * @param string $statement_descriptor
   * @return mixed
   */
  public function createApplePayDirectPayIn($user_id, $wallet_id, $amount, $currency_code, $transaction_id, $network, $token_data, $statement_descriptor = '');

  /**
   * @param $payin_id
   */
  public function getPayIn($payin_id);

  public function createGooglePayDirectPayIn(
    string $user_id,
    string $wallet_id,
    int $amount,
    string $currency_code,
    string $payment_data,
    string $statement_descriptor,
    string $ip_address,
    BrowserInfo $browser_info,
    Billing $billing,
    string $secure_mode_return_url
  ): PayIn;

  /**
   * @return mixed
   */
  public function getGooglePaySettings(): array;
}
