<?php

namespace Drupal\commerce_mangopay_dpi\Plugin\Commerce\PaymentMethodType;

use \Drupal\entity\BundleFieldDefinition;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType;
use Drupal\commerce_payment\CreditCard as CreditCardHelper;

/**
 * Provides the apple pay payment method type.
 *
 * @CommercePaymentMethodType(
 *   id = "commerce_mangopay_dpi_apple_pay",
 *   label = @Translation("Apple Pay"),
 * )
 */
class ApplePay extends PaymentMethodType\PaymentMethodTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    $args = [
      '@wallet_id' => $payment_method->wallet_id->value,
    ];
    return $this->t('Apple Pay (@wallet_id)', $args);
  }

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    $fields['user_id'] = BundleFieldDefinition::create('string')
    ->setLabel(t('MANGOPAY User Id'))
    ->setDescription(t('Remote User Id for MANGOPAY API'))
    ->setRequired(TRUE);

    $fields['wallet_id'] = BundleFieldDefinition::create('string')
    ->setLabel(t('MANGOPAY Wallet Id'))
    ->setDescription(t('Remote Wallet Id for MANGOPAY API'))
    ->setRequired(TRUE);

    $fields['currency_code'] = BundleFieldDefinition::create('string')
    ->setLabel(t('Card currency code'))
    ->setDescription(t('Currency code for this card'))
    ->setRequired(TRUE);

    $fields['name'] = BundleFieldDefinition::create('string')
    ->setLabel(t('Payer name'))
    ->setDescription(t('Payer name'))
    ->setRequired(TRUE);

    $fields['country'] = BundleFieldDefinition::create('string')
    ->setLabel(t('Payer country'))
    ->setDescription(t('Payer country'))
    ->setRequired(TRUE);

    $fields['nationality'] = BundleFieldDefinition::create('string')
    ->setLabel(t('Payer nationality'))
    ->setDescription(t('Payer nationality'))
    ->setRequired(TRUE);

    $fields['transaction_id'] = BundleFieldDefinition::create('string')
    ->setLabel(t('Transaction ID'))
    ->setDescription(t('Transaction ID this payment method is created for'))
    ->setRequired(TRUE);

    $fields['network'] = BundleFieldDefinition::create('string')
    ->setLabel(t('Network'))
    ->setDescription(t('Network this payment method is created for'))
    ->setRequired(TRUE);

    $fields['token_data'] = BundleFieldDefinition::create('string_long')
    ->setLabel(t('Token Data'))
    ->setDescription(t('Token Data this payment method is created for'))
    ->setRequired(TRUE);

    return $fields;
  }
}
