<?php

declare(strict_types=1);

namespace Drupal\commerce_mangopay_dpi\Plugin\Commerce\PaymentMethodType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use \Drupal\entity\BundleFieldDefinition;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType;

/**
 * Provides the Google Pay payment method type.
 *
 * @CommercePaymentMethodType(
 *   id = "commerce_mangopay_dpi_google_pay",
 *   label = @Translation("Google Pay"),
 * )
 */
class GooglePay extends PaymentMethodType\PaymentMethodTypeBase {

  /**
   * @inheritdoc
   */
  public function buildLabel(PaymentMethodInterface $payment_method): TranslatableMarkup
  {
    $args = [
      '@wallet_id' => $payment_method->wallet_id->value,
    ];
    return $this->t('Google Pay (@wallet_id)', $args);
  }

  /**
   * @inheritdoc
   * @return mixed[]
   */
  public function buildFieldDefinitions(): array {
    $fields = parent::buildFieldDefinitions();

    $fields['user_id'] = BundleFieldDefinition::create('string')
      ->setLabel(t('MANGOPAY User Id'))
      ->setDescription(t('Remote User Id for MANGOPAY API'))
      ->setRequired(TRUE);

    $fields['wallet_id'] = BundleFieldDefinition::create('string')
      ->setLabel(t('MANGOPAY Wallet Id'))
      ->setDescription(t('Remote Wallet Id for MANGOPAY API'))
      ->setRequired(TRUE);

    $fields['currency_code'] = BundleFieldDefinition::create('string')
      ->setLabel(t('Card currency code'))
      ->setDescription(t('Currency code for this card'))
      ->setRequired(TRUE);

    $fields['name'] = BundleFieldDefinition::create('string')
      ->setLabel(t('Payer name'))
      ->setDescription(t('Payer name'))
      ->setRequired(TRUE);

    $fields['country'] = BundleFieldDefinition::create('string')
      ->setLabel(t('Payer country'))
      ->setDescription(t('Payer country'))
      ->setRequired(TRUE);

    $fields['token_data'] = BundleFieldDefinition::create('string_long')
      ->setLabel(t('Token data'))
      ->setDescription(t('Token data this payment method is created for'))
      ->setRequired(TRUE);

    return $fields;
  }
}
