<?php

declare(strict_types=1);

namespace Drupal\commerce_mautic_connect\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a MauticFeature attribute for plugin discovery.
 *
 * MauticFeature plugins provide configuration tabs for the Commerce Mautic
 * Connect settings form. Each plugin represents a distinct feature that can
 * be enabled/configured, such as Abandoned Cart sync or Customer Metrics.
 *
 * Example usage:
 * @code
 * #[MauticFeature(
 *   id: 'abandoned_cart',
 *   label: new TranslatableMarkup('Abandoned Cart'),
 *   weight: 0,
 * )]
 * class AbandonedCart extends MauticFeaturePluginBase {
 *   // Plugin implementation.
 * }
 * @endcode
 *
 * @see \Drupal\commerce_mautic_connect\MauticFeaturePluginInterface
 * @see \Drupal\commerce_mautic_connect\MauticFeaturePluginBase
 * @see \Drupal\commerce_mautic_connect\MauticFeaturePluginManager
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class MauticFeature extends Plugin {

  /**
   * Constructs a MauticFeature attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable label of the feature, displayed as the tab title.
   * @param int $weight
   *   (optional) The weight for ordering tabs. Lower weights appear first.
   *   Defaults to 0.
   * @param class-string|null $deriver
   *   (optional) The deriver class for dynamic plugin definitions.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly int $weight = 0,
    public readonly ?string $deriver = NULL,
  ) {}

}

