<?php

namespace Drupal\commerce_mautic_connect\Service;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\Component\Utility\Crypt;
use Drupal\Core\Site\Settings;

/**
 * Service for generating and validating cart recovery tokens.
 */
class CartRecoveryService {

  /**
   * Generates a secure token for a cart order.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $order
   *   The order entity.
   *
   * @return string
   *   The generated token.
   */
  public function generateToken(OrderInterface $order) {
    $data = $order->id() . ':' . $order->getCreatedTime();
    return Crypt::hmacBase64($data, Settings::getHashSalt());
  }

  /**
   * Validates a token for a given order.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $order
   *   The order entity.
   * @param string $token
   *   The token to validate.
   *
   * @return bool
   *   TRUE if the token is valid, FALSE otherwise.
   */
  public function validateToken(OrderInterface $order, $token) {
    $expected_token = $this->generateToken($order);
    return hash_equals($expected_token, $token);
  }

}

