# Commerce MICB

The Commerce MICB (Moldindconbank) Drupal Module is used to easily integrate
the MICB Payment into your project.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/commerce_micb).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/commerce_micb).


## Requirements

- [Commerce module](https://www.drupal.org/project/commerce)


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

After installation, add a new payment Gateway on
`admin/commerce/config/payment-gateways`:

1. Select MICB (Off-site redirect) Plugin.
2. Give name, display name.
3. Select the mode (Default is Test).
4. Send an email with your IP and Callback URL from
   `"IPN callback for sending notifications to be provided to the bank"`
   in order to obtain access to the bank APIs.
5. Merchant name, terminal are sent by the bank.
6. Add iso2 for your country, select store category.
7. Set the paths to private key, bank public certificate/key and optionally
   for the public key, if required set the password for the private key. This
   should be created/obtained accordingly to bank's guide.
   For tests use keys provided by this module and are set by default.
8. Gateway URLs are provided by bank, please check they are similar to defaults
   provided by module.
9. Select the Transaction type.
    1. Capture (capture payment immediately after customer's approval)
    2. Authorize (requires later manual or automated capture after checkout)
7. Check the `"Log debug info"` checkbox in order to write all requests and
   responses to the bank APIs into log file.
8. Set up the conditions you want. Order currency restrictions are recommended.
9. Set the Status to Enabled
10. Save the configuration form.


## Usage

Use bank guidelines to create few test payments with different transaction
types.

To change the mode to Live, you will need:

1. Send RRNs for payment operations of different types. RRNs can be found on
   order > payments page or in watchdog.
2. Obtain keys/certificates for production environment and set paths for then
   in the payment's plugin configuration form.


## Maintainers

- dscutaru - [dscutaru](https://www.drupal.org/u/dscutaru)
- dangolovatic - [dangolovatic](https://www.drupal.org/u/dangolovatic)

## Sponsoring

This module is developed and maintained by [Indrivo](https://www.indrivo.com),
a technology company specializing in digital solutions and e-commerce integrations.
