<?php

namespace Drupal\commerce_micb\Event;

use Drupal\commerce_payment\Entity\PaymentInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Defines the MicbSendAuthorizationDataEvent event.
 */
class MicbSendAuthorizationDataEvent extends Event {

  /**
   * The authorization data.
   *
   * @var array
   */
  protected array $authorizationData = [];

  /**
   * The payment.
   *
   * @var \Drupal\commerce_payment\Entity\PaymentInterface
   */
  protected PaymentInterface $payment;

  /**
   * Constructs a new MicbSendAuthorizationDataEvent object.
   *
   * @param array $authorization_data
   *   Authorization data to be sent to the gateway.
   * @param \Drupal\commerce_payment\Entity\PaymentInterface $payment
   *   The payment.
   */
  public function __construct(
    array $authorization_data,
    PaymentInterface $payment,
  ) {
    $this->authorizationData = $authorization_data;
    $this->payment = $payment;
  }

  /**
   * Gets the authorization data.
   *
   * @return array
   *   The authorization data.
   */
  public function getAuthorizationData() {
    return $this->authorizationData;
  }

  /**
   * Sets the authorization data.
   *
   * @param array $authorization_data
   *   Authorization data to be sent to the gateway.
   */
  public function setAuthorizationData(array $authorization_data) {
    $this->authorizationData = $authorization_data;
  }

  /**
   * Gets the payment object authorization data is extracted from.
   *
   * @return \Drupal\commerce_payment\Entity\PaymentInterface
   *   The payment.
   */
  public function getPayment() {
    return $this->payment;
  }

}
