# Commerce Moyasar

## CONTENTS OF THIS FILE

- Introduction
- Requirements
- Installation
- Configuration
- How it works
- Maintainers

## INTRODUCTION

**Commerce Moyasar** is [Drupal Commerce](https://drupal.org/project/commerce)
module that integrates the [hyperpay.com](https://moyasar.com/) payement
gateway into your Drupal Commerce shop.

## REQUIREMENTS

This module requires the following:

- Submodules of Drupal Commerce package (https://drupal.org/project/commerce)
  - Commerce core
  - Commerce Payment (and its dependencies)
- Hyperpay.com merchant account (test or live) (https://www.hyperpay.com/)

## INSTALLATION

Open your terminal and download with composer.
composer require drupal/commerce_moyasar

OR

1. Download the module to your DRUPAL_ROOT/modules directory,
   or where ever you install contrib modules on your site.
2. Go to Admin > Extend and enable the module.

## CONFIGURATION

- Create a new Moyasar payment gateway.
  Administration > Commerce > Configuration > Payment gateways > Add payment gateway
  Moyasar specific settings available:
  - Mode
  - Publishable API key
  - Secret API key
  - Allowed methods
  - Supported networks
  - Allow reusing payment method

## HOW IT WORKS

- Moyasar
  Moyasar payment is an Iframe embeded on the checkout page.

- 3DS support:
  Handled by the HyperPay Moyasar Iframe.

- Checkout workflow:
  It follows the Drupal Commerce Credit Card workflow.
  The customer should enter his/her credit card data
  or select one of the credit cards saved with Moyasar.com
  from a previous order.

- Payment Terminal
  The store owner can Void, Capture and Refund the Moyasar.com payments.

## MAINTAINERS

- Anas Mawlawi (Anas_maw) - <https://www.drupal.org/u/anas_maw>
- Yasser Samman (yasser-samman) - https://www.drupal.org/u/yasser-samman

This project has been developed by:

- Coders Enterprise Web & Mobile Solutions: https://www.codersme.com/
