# Commerce National Bank of Greece (NBG) Redirect

Provides a payment gateway for [Drupal Commerce](https://www.drupal.org/project/commerce)
that integrates with the National Bank of Greece (NBG) using the
[GlobalPayments Hosted Payment Page](https://developer.globalpayments.com/docs/payments/online/hosted-payment-page-overview) and the [GlobalPayments PHP SDK](https://github.com/globalpayments/php-sdk)

## Features

- Offsite redirect payment flow using GlobalPayments Hosted Payment Page
- Support for major credit cards (Visa, Mastercard, American Express, and more)
- (Needs testing) Google Pay and Apple Pay digital wallet support
- 3D Secure authentication
- Test and Live environment modes
- Secure webhook signature validation

## Known Issues

### GlobalPayments SDK Symfony Compatibility

The official `globalpayments/php-sdk` package has a Symfony component version
constraint that conflicts with Drupal 11. A
[pull request](https://github.com/globalpayments/php-sdk/pull/132) has been
submitted to fix this issue.

Until the fix is merged, this module requires a
[forked version of the SDK](https://github.com/anpel/globalpayments-php-sdk)
with the corrected dependency constraints. The fork is automatically used
when installing this module via Composer.

## Installation

Install via Composer (recommended):

```bash
composer require drupal/commerce_nbg_redirect
```

Then enable the module:

```bash
drush en commerce_nbg_redirect
```

## Configuration

1. Navigate to /admin/commerce/config/payment-gateways
2. Click **Add payment gateway**
3. Select **National Bank of Greece (Redirect)** as the plugin
4. Configure the following settings:

| Setting | Description |
|---------|-------------|
| **Name** | Administrative name |
| **Display name** | The name shown to customers during checkout |
| **Mode** | Select Test or Live environment |
| **Merchant Country Code** | Your merchant country code (e.g., `GR` for Greece) |
| **Merchant ID** | Your NBG merchant identifier |
| **App ID** | Your GlobalPayments API application ID |
| **App Key** | Your GlobalPayments API application key |

5. Save the configuration

## Obtaining API Credentials

To obtain your API credentials:

1. Access the [GlobalPayments Developer Portal](https://developer.globalpay.com/)
2. Create an application to receive your sandbox App ID and App Key

## Troubleshooting

### Payment callback not working

Ensure your site is accessible from the internet and the callback URL
`/commerce-nbg-redirect/return-url` is not blocked by any firewall or
authentication.

## Support

- [Issue queue](https://www.drupal.org/project/issues/commerce_nbg_redirect)

## Contributing

Contributions are welcome! Please read the
[Drupal contribution guidelines](https://www.drupal.org/docs/develop/issues/issue-procedures-and-etiquette)
before submitting patches.

## License

This project is licensed under the
[GNU General Public License, version 2 or later](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html).
