(function ($, Drupal, once) {
  Drupal.behaviors.nexiCheckout = {
    attach: function (context, settings) {
      once('attach-nexi-once', 'body', context).forEach(function (el) {
        // Listen for iframe messages.
        window.addEventListener('message', function (event) {
          if (event.data && event.data.type === 'payment-redirect') {
            // Redirect parent window after payment processed.
            window.location.href = event.data.redirect;
          }
        });
      });
    }
  };
})(jQuery, Drupal, once);
