<?php

namespace Drupal\commerce_nexi\EventSubscriber;

use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Routing\LocalRedirectResponse;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Class of CheckoutFormEventSusbcriber.
 */
class CheckoutFormEventSubscriber implements EventSubscriberInterface {

  use StringTranslationTrait;

  /**
   * The route match.
   *
   * @var \Drupal\Core\Routing\RouteMatchInterface
   */
  protected $routeMatch;

  /**
   * The messenger.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface
   */
  protected $messenger;

  /**
   * {@inheritdoc}
   */
  public function __construct(RouteMatchInterface $routeMatch, MessengerInterface $messenger) {
    $this->routeMatch = $routeMatch;
    $this->messenger = $messenger;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      KernelEvents::REQUEST => 'onKernelRequest',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function onKernelRequest(RequestEvent $event) {
    $current_request = $event->getRequest();
    if ($this->routeMatch->getRouteName() !== 'commerce_checkout.form') {
      return;
    }
    $payment_result = $current_request->query->get('payment_result');
    if (empty($payment_result)) {
      return;
    }
    switch ($payment_result) {
      case 'gateway_error':
        $this->messenger->addError($this->t('Payment failed at the payment server. Please review your information and try again.'));
        break;

      case 'local_error':
        $this->messenger->addError($this->t('We encountered an issue recording your payment. Please review your information and try again.'));
        break;

      case 'cancel':
        $this->messenger->addMessage($this->t('You have canceled payment but may resume the checkout process here when you are ready.'));
        break;

      default:
        return;
    }
    $response = new LocalRedirectResponse($current_request->getPathInfo());
    $event->setResponse($response);
  }

}
