<?php

namespace Drupal\commerce_nexi\Plugin\Commerce\PaymentMethodType;

use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\CreditCard;
use Drupal\entity\BundleFieldDefinition;

/**
 * Provides the Nexi credit card payment method type.
 *
 * @CommercePaymentMethodType(
 *   id = "nexi_credit_card",
 *   label = @Translation("Nexi credit card"),
 * )
 */
class NexiCreditCard extends CreditCard {

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    return $payment_method->getPaymentGateway()?->getPlugin()?->getDisplayLabel() ?? $this->t('Nexi credit card payment');
  }

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    $fields['card_type'] = BundleFieldDefinition::create('list_string')
      ->setLabel($this->t('Card type'))
      ->setDescription($this->t('The credit card type.'))
      ->setRequired(TRUE)
      ->setSetting('allowed_values_function', ['\Drupal\commerce_payment\CreditCard', 'getTypeLabels']);

    $fields['card_number'] = BundleFieldDefinition::create('string')
      ->setLabel($this->t('Card number'))
      ->setDescription($this->t('The last few digits of the credit card number'))
      ->setRequired(TRUE);

    $fields['card_exp_month'] = BundleFieldDefinition::create('integer')
      ->setLabel($this->t('Card expiration month'))
      ->setDescription($this->t('The credit card expiration month.'))
      ->setSetting('size', 'tiny');

    $fields['card_exp_year'] = BundleFieldDefinition::create('integer')
      ->setLabel($this->t('Card expiration year'))
      ->setDescription($this->t('The credit card expiration year.'))
      ->setSetting('size', 'small');

    $fields['recurring'] = BundleFieldDefinition::create('boolean')
      ->setLabel($this->t('Card can be used for recurring payments'))
      ->setDescription($this->t('Card can be used for recurring payments.'));

    return $fields;
  }

}
