<?php

namespace Drupal\commerce_opp\Plugin\Commerce\PaymentGateway;

/**
 * Provides the Open Payment Platform COPYandPAY gateway for bank accounts.
 *
 * @CommercePaymentGateway(
 *   id = "opp_copyandpay_bank",
 *   label = "Open Payment Platform COPYandPAY (bank transfer)",
 *   display_label = "Bank transfer",
 *   forms = {
 *     "offsite-payment" = "Drupal\commerce_opp\PluginForm\CopyAndPayForm",
 *   },
 *   payment_method_types = {"opp_bank"},
 *   payment_type = "opp",
 *   requires_billing_information = FALSE,
 * )
 */
class CopyAndPayBank extends CopyAndPayBase {

  /**
   * {@inheritdoc}
   */
  protected function getBrandOptions(): array {
    return $this->brandRepository->getBankAccountBrandLabels();
  }

}
