<?php

namespace Drupal\commerce_opp\Plugin\Commerce\PaymentGateway;

/**
 * Provides the Open Payment Platform COPYandPAY gateway for credit cards.
 *
 * @CommercePaymentGateway(
 *   id = "opp_copyandpay_card",
 *   label = "Open Payment Platform COPYandPAY (credit cards)",
 *   display_label = "Credit card",
 *   forms = {
 *     "offsite-payment" = "Drupal\commerce_opp\PluginForm\CopyAndPayForm",
 *   },
 *   payment_type = "opp",
 *   payment_method_types = {"opp_card"},
 *   credit_card_types = {
 *     "amex",
 *     "dinersclub",
 *     "discover",
 *     "jcb",
 *     "maestro",
 *     "mastercard",
 *     "unionpay",
 *     "visa",
 *   },
 *   requires_billing_information = FALSE,
 * )
 */
class CopyAndPayCard extends CopyAndPayBase {

  /**
   * {@inheritdoc}
   */
  protected function allowMultipleBrands(): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  protected function getBrandOptions(): array {
    return $this->brandRepository->getCardAccountBrandLabels();
  }

  /**
   * {@inheritdoc}
   */
  public function allowRegistrations(): bool {
    return TRUE;
  }

}
