<?php

namespace Drupal\commerce_opp\Plugin\Commerce\PaymentMethodType;

use Drupal\commerce_opp\BrandRepositoryInterface;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\CreditCard;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\entity\BundleFieldDefinition;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides the Open Payment Platform card payment method type.
 *
 * @CommercePaymentMethodType(
 *   id = "opp_card",
 *   label = @Translation("Credit card"),
 * )
 */
class OppCard extends CreditCard implements ContainerFactoryPluginInterface {

  /**
   * The brand repository.
   *
   * @var \Drupal\commerce_opp\BrandRepositoryInterface
   */
  protected BrandRepositoryInterface $brandRepository;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = new static(
      $configuration,
      $plugin_id,
      $plugin_definition
    );

    $instance->brandRepository = $container->get('commerce_opp.brand_repository');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    if ($payment_method->hasField('card_type') && !$payment_method->get('card_type')->isEmpty()) {
      return parent::buildLabel($payment_method);
    }
    if ($payment_method->hasField('opp_brand') && !$payment_method->get('opp_brand')->isEmpty()) {
      $brand_id = $payment_method->get('opp_brand')->getString();
      if ($brand = $this->brandRepository->getBrand($brand_id)) {
        return $brand->getLabel();
      }
    }
    return $this->t('Credit card');
  }

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    $fields['opp_brand'] = BundleFieldDefinition::create('string')
      ->setLabel($this->t('Brand'))
      ->setDescription($this->t('The Open Payment Platform brand ID.'))
      ->setRequired(TRUE);

    return $fields;
  }

}
