<?php

namespace Drupal\commerce_opp\Plugin\Commerce\PaymentMethodType;

use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\PayPal;
use Drupal\entity\BundleFieldDefinition;

/**
 * Provides the Open Payment Platform virtual account payment method type.
 *
 * @CommercePaymentMethodType(
 *   id = "opp_paypal",
 *   label = @Translation("PayPal"),
 * )
 */
class OppPaypal extends PayPal {

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    $fields['opp_brand'] = BundleFieldDefinition::create('string')
      ->setLabel($this->t('Brand'))
      ->setDescription($this->t('The Open Payment Platform brand ID.'))
      ->setRequired(TRUE);

    return $fields;
  }

}
