<?php

declare(strict_types=1);

namespace Drupal\commerce_order_item_sku_test;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Modifies the cart subscriber.
 */
class CommerceOrderItemSkuTestServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container): void {
    if ($container->hasDefinition('commerce_cart.cart_subscriber')) {
      $definition = $container->getDefinition('commerce_cart.cart_subscriber');
      $definition->setClass('Drupal\commerce_order_item_sku_test\EventSubscriber\CartEventSubscriber');
    }
  }

}
