<?php

declare(strict_types=1);

namespace Drupal\commerce_order_item_sku\Plugin\Commerce\EntityTrait;

use Drupal\commerce\Attribute\CommerceEntityTrait;
use Drupal\commerce\Plugin\Commerce\EntityTrait\EntityTraitBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\entity\BundleFieldDefinition;

/**
 * Provides the "commerce_order_item_sku" trait.
 */
#[CommerceEntityTrait(
  id: "commerce_order_item_sku",
  label: new TranslatableMarkup("Store purchased entity SKU"),
  entity_types: ["commerce_order_item"]
)]
class OrderItemSkuTrait extends EntityTraitBase {

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions(): array {
    $fields = [];
    $fields['sku'] = BundleFieldDefinition::create('string')
      ->setLabel(new TranslatableMarkup('SKU'))
      ->setDescription(new TranslatableMarkup('The unique, machine-readable identifier for a purchased entity.'))
      ->setRequired(TRUE)
      ->setSetting('display_description', TRUE)
      ->setDisplayOptions('form', [
        'type' => 'string_textfield',
        'weight' => -4,
      ])
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayConfigurable('view', TRUE);

    return $fields;
  }

}
