<?php

namespace Drupal\commerce_order_item_sku\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\Plugin\Field\FieldFormatter\StringFormatter;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'commerce_order_item_sku' formatter.
 */
#[FieldFormatter(
  id: "commerce_order_item_sku",
  label: new TranslatableMarkup("SKU or purchased entity SKU"),
  field_types: ["string"]
)]
class OrderItemSkuFormatter extends StringFormatter implements ContainerFactoryPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $item = $items->first();
    $sku = $item ? $item->value : '';

    if ($sku) {
      return parent::viewElements($items, $langcode);
    }

    $elements = [];
    $sku = '';
    $purchased_entity = $items->getEntity()->getPurchasedEntity();
    if ($purchased_entity) {
      $sku = $purchased_entity->get('sku')->value;
    }

    $elements[0] = [
      '#markup' => $sku,
    ];

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public static function isApplicable(FieldDefinitionInterface $field_definition) {
    return $field_definition->getTargetEntityTypeId() === 'commerce_order_item' && $field_definition->getName() === 'sku';
  }

}
