<?php

namespace Drupal\Tests\commerce_order_item_sku\Kernel;

use Drupal\commerce_order\Entity\Order;
use Drupal\commerce_order\Entity\OrderItem;
use Drupal\commerce_product\Entity\ProductVariation;

/**
 * Tests the commerce_order_item_sku_commerce_order_item_presave() function.
 *
 * @group commerce_order_item_sku
 */
class OrderItemAddToCartTest extends OrderItemSkuKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'commerce_order_item_sku',
    'commerce_order_item_sku_test',
    'commerce_cart',
  ];

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The cart manager.
   *
   * @var \Drupal\commerce_cart\CartManagerInterface
   */
  protected $cartManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installOrderItemTypeTrait('default');

    $this->cartManager = $this->container->get('commerce_cart.cart_manager');

    $this->configFactory->getEditable('commerce_order_item_sku.settings')
      ->set('setting_event', 'order_item_add')
      ->set('sync_on_purchasable_entity_sku_update', FALSE)
      ->set('sync_on_purchased_entity_reference_update', FALSE)
      ->save();

    $variation = ProductVariation::create([
      'type' => 'default',
      'sku' => 'ORIGINAL_SKU',
    ]);
    $variation->save();

    $order = Order::create([
      'type' => 'default',
      'state' => 'draft',
      'cart' => TRUE,
      'store_id' => $this->store->id(),
    ]);
    $order->save();
  }

  /**
   * Tests the entity update.
   */
  public function testOrderItemAddToCart() {
    $order = Order::load(1);
    $variation = ProductVariation::load(1);

    $this->cartManager->addEntity($order, $variation, 1);

    $order_item = OrderItem::load(1);
    $this->assertEquals(
      'ORIGINAL_SKU',
      $order_item->get('sku')->value,
      'The order item SKU should be set.'
    );
  }

}
