<?php

namespace Drupal\Tests\commerce_order_item_sku\Kernel;

use Drupal\commerce_order\Entity\OrderItem;
use Drupal\commerce_product\Entity\ProductVariation;

/**
 * Tests the commerce_order_item_sku_commerce_order_item_presave() function.
 *
 * @group commerce_order_item_sku
 */
class OrderItemPresaveTest extends OrderItemSkuKernelTestBase {

  /**
   * An unsaved order item.
   *
   * @var \Drupal\commerce_order\Entity\OrderItemInterface
   */
  protected $orderItem;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installConfig(['commerce_order_item_sku']);

    $this->configFactory->getEditable('commerce_order_item_sku.settings')
      ->set('setting_event', 'order_item_presave')
      ->set('sync_on_purchasable_entity_sku_update', FALSE)
      ->set('sync_on_purchased_entity_reference_update', FALSE)
      ->save();

    $variation = ProductVariation::create([
      'type' => 'default',
      'sku' => 'ORIGINAL_SKU',
    ]);
    $variation->save();

    $variation_2 = ProductVariation::create([
      'type' => 'default',
      'sku' => 'ANOTHER_SKU',
    ]);
    $variation_2->save();

    $this->orderItem = OrderItem::create([
      'type' => 'default',
      'purchased_entity' => $variation->id(),
    ]);
  }

  /**
   * Tests the entity update.
   */
  public function testOrderItemPresave() {
    $this->assertIsInt(
      $this->orderItem->save(),
      SAVED_NEW,
      'The order item was ot saved successfully.'
    );

    $this->installOrderItemTypeTrait('default');

    $order_item = OrderItem::load(1);
    $order_item->save();
    $this->assertEquals(
      NULL,
      $order_item->get('sku')->value,
      'The order item SKU should not be set because the order_item is not new anymore.'
    );

    $order_item = $order_item->createDuplicate();
    $order_item->save();
    $this->assertEquals(
      'ORIGINAL_SKU',
      $order_item->get('sku')->value,
      'The order item SKU should be set.'
    );

    $variation_2 = ProductVariation::load(2);
    $order_item->set('purchased_entity', $variation_2);
    $order_item->save();

    $this->assertEquals(
      'ORIGINAL_SKU',
      $order_item->get('sku')->value,
      'The order item SKU should not be updated.'
    );

    $variation = ProductVariation::load(1);
    $order_item->set('purchased_entity', $variation);
    $order_item->save();

    $this->configFactory->getEditable('commerce_order_item_sku.settings')
      ->set('sync_on_purchased_entity_reference_update', TRUE)
      ->save();

    $variation_2 = ProductVariation::load(2);
    $order_item->set('purchased_entity', $variation_2);
    $order_item->save();

    $this->assertEquals(
      'ANOTHER_SKU',
      $order_item->get('sku')->value,
      'The order item SKU should be updated.'
    );

    $order_item->set('sku', 'UPDATED_SKU');
    $order_item->save();

    $variation = ProductVariation::load(1);
    $order_item->set('purchased_entity', $variation);
    $order_item->save();

    $this->assertEquals(
      'UPDATED_SKU',
      $order_item->get('sku')->value,
      'The order item SKU should not be updated.'
    );
  }

}
