<?php

namespace Drupal\Tests\commerce_order_item_sku\Kernel;

use Drupal\commerce_order\Entity\OrderItem;
use Drupal\commerce_order\Entity\OrderItemType;
use Drupal\commerce_product\Entity\ProductVariation;

/**
 * Tests the OrderItemSkuFormatter field formatter.
 *
 * @group commerce_order_item_sku
 */
class OrderItemSkuFormatterTest extends OrderItemSkuKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['commerce_order_item_sku'];

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The order item.
   *
   * @var \Drupal\commerce_order\Entity\OrderItemInterface
   */
  protected $orderItem;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installOrderItemTypeTrait('default');

    $this->configFactory->getEditable('commerce_order_item_sku.settings')
      ->set('setting_event', 'none')
      ->set('sync_on_purchasable_entity_sku_update', FALSE)
      ->set('sync_on_purchased_entity_reference_update', FALSE)
      ->save();

    $variation = ProductVariation::create([
      'type' => 'default',
      'sku' => 'TEST_SKU',
    ]);
    $variation->save();

    $this->orderItem = OrderItem::create([
      'type' => 'default',
      'purchased_entity' => $variation->id(),
    ]);
    $this->orderItem->save();
  }

  /**
   * Tests the field formatter.
   */
  public function testFieldFormatter() {
    // Test with an empty SKU field.
    $this->orderItem->set('sku', '');
    $this->orderItem->save();

    $build = $this->orderItem->get('sku')->view([
      'label' => 'hidden',
      'type' => 'commerce_order_item_sku',
    ]);
    $rendered = \Drupal::service('renderer')->renderInIsolation($build);

    $this->assertStringContainsString('TEST_SKU', $rendered, 'The formatter outputs the purchased entity SKU when the field is empty.');

    // Test with a non-empty SKU field.
    $this->orderItem->set('sku', 'ORDER_ITEM_SKU');
    $this->orderItem->save();

    $build = $this->orderItem->get('sku')->view([
      'label' => 'hidden',
      'type' => 'commerce_order_item_sku',
    ]);
    $rendered = \Drupal::service('renderer')->renderInIsolation($build);

    $this->assertStringContainsString('ORDER_ITEM_SKU', $rendered, 'The formatter outputs the order item SKU when the field is not empty.');
  }

}
