<?php

namespace Drupal\Tests\commerce_order_item_sku\Kernel;

use Drupal\commerce_order\Entity\OrderItemType;
use Drupal\Tests\commerce_order\Kernel\OrderKernelTestBase;

/**
 * Base class for Order Item SKU kernel tests.
 *
 * @group commerce_order_item_sku
 */
abstract class OrderItemSkuKernelTestBase extends OrderKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['commerce_order_item_sku'];

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installConfig(['commerce_order_item_sku']);
    $this->configFactory = $this->container->get('config.factory');
  }

  /**
   * Installs the commerce_order_item_sku trait on the default order item type.
   */
  protected function installOrderItemTypeTrait(string $order_item_type_id): void {
    $order_item_type = OrderItemType::load($order_item_type_id);
    $order_item_type->setTraits(['commerce_order_item_sku']);
    $order_item_type->save();

    $trait_manager = $this->container->get('plugin.manager.commerce_entity_trait');
    $trait = $trait_manager->createInstance('commerce_order_item_sku');
    $trait_manager->installTrait($trait, 'commerce_order_item', 'default');
  }

}
