<?php

namespace Drupal\Tests\commerce_order_item_sku\Kernel;

use Drupal\commerce_order\Entity\Order;
use Drupal\commerce_order\Entity\OrderItem;
use Drupal\commerce_product\Entity\ProductVariation;

/**
 * Tests the commerce_order_item_sku_commerce_order_item_presave() function.
 *
 * @group commerce_order_item_sku
 */
class OrderPlacedTest extends OrderItemSkuKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['commerce_order_item_sku'];

  /**
   * The order refresh service.
   *
   * @var \Drupal\commerce_order\OrderRefreshInterface
   */
  protected $orderRefresh;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installOrderItemTypeTrait('default');

    $this->orderRefresh = $this->container->get('commerce_order.order_refresh');

    $this->configFactory->getEditable('commerce_order_item_sku.settings')
      ->set('setting_event', 'order_placed')
      ->set('sync_on_purchasable_entity_sku_update', FALSE)
      ->set('sync_on_purchased_entity_reference_update', FALSE)
      ->save();

    $variation = ProductVariation::create([
      'type' => 'default',
      'sku' => 'ORIGINAL_SKU',
    ]);
    $variation->save();

    $order_item = OrderItem::create([
      'type' => 'default',
      'purchased_entity' => $variation->id(),
    ]);
    $order_item->save();

    $order = Order::create([
      'type' => 'default',
      'state' => 'draft',
      'store_id' => $this->store->id(),
      'order_items' => [$order_item],
    ]);
    $order->save();
  }

  /**
   * Tests the entity update.
   */
  public function testOrderPlaced() {
    $order = Order::load(1);

    $order_item = $order->getItems()[0];
    $this->assertNull(
      $order_item->get('sku')->value,
      'The order item SKU should not be set for a draft order.'
    );

    $order->getState()->applyTransitionById('place');
    $order->save();

    $this->assertEquals(
      'ORIGINAL_SKU',
      $order_item->get('sku')->value,
      'The order item SKU should be set on a placed order.'
    );
  }

}
