(function ($, Drupal) {
  Drupal.behaviors.packetaWidget = {
    attach: function (context, settings) {

      $('.packeta-selector-open').on('click', function () {

        let appIdentity = drupalSettings.version;

        let options = {
          webUrl: drupalSettings.path.baseUrl,
          country: this.dataset.country,
          language: drupalSettings.language,
          appIdentity: appIdentity,
          fontFamily: drupalSettings.packetaWidgetFont,
        }

        Packeta.Widget.pick(drupalSettings.packetaApiKey, function (pickupPoint) {
          if (pickupPoint != null) {
            $('.packeta-selected-point-id').val(pickupPoint.id);

            let name = pickupPoint.place + ', ' + pickupPoint.street + ', ' + pickupPoint.city + ' ' + pickupPoint.zip + ', ' + pickupPoint.country.toUpperCase();
            $('.packeta-selected-point-name-value').val(name);

            $('.packeta-selected-point-name .point-name-value').text(name);
          }
        }, options);
      });
    }
  }
}(jQuery, Drupal));
