# Commerce Pay Publish

A Drupal module that provides paid publishing functionality for nodes with
expiration and relisting features.

## Features

- **Product Type Creation**: Defines a new "Node Associated Product" type for
  products linked to nodes
- **Content Type Configuration**: Select which node types require payment to
  publish
- **Expiration Duration**: Products include configurable expiration durations
  (1 day to 1 year)
- **Automatic Unpublishing**: Nodes are unpublished by default upon creation
- **Payment Integration**: Redirects to payment page when nodes are created
- **Auto-Publishing**: Nodes are published after successful payment completion
- **Expiration Management**: Automatic unpublishing when content expires
- **Email Notifications**:
  - Expiration notifications with relist links
  - Publish confirmation emails
- **Relist Functionality**:
  - "Relist" button on unpublished nodes
  - Multiple payment options for relisting
  - Easy payment selection form

## Installation

1. Enable the module: `drush en commerce_pay_publish`
2. Configure settings at: `/admin/config/commerce/commerce-pay-publish`
3. 3. Create products of type "Node Associated Product" and link them to nodes.
4. Configure enabled content types in the module settings

## Configuration

### Module Settings
- **Content Types**: Select which node types require payment to publish
- **Email Templates**: Customize expiration and publish notification emails

### Product Setup
1. Go to `/admin/commerce/products/add/node_associated_product`
2. Set the product title and pricing
3. Configure the expiration duration (1 day, 1 week, 1 month, etc.)
4. Set the bundle quantity if needed
5. Save the product

### Content Type Configuration
1. Go to `/admin/config/commerce/commerce-pay-publish`
2. Select the content types that should require payment
3. Configure email notification templates
4. Save the configuration

## Usage

### Creating Paid Content
1. Create a new node of an enabled content type
2. Select a payment option from the available products
3. Complete the node creation form
4. You'll be redirected to the payment page
5. After successful payment, the node will be published

### Relisting Expired Content
1. When content expires, the author receives an email notification
2. The email includes a direct link to relist the content
3. Alternatively, unpublished nodes show a "Relist" button
4. Click the relist link/button to select a new payment option
5. Complete payment to republish the content

## Technical Details

### Services
- `commerce_pay_publish.payment_handler`: Handles payment processing
- `commerce_pay_publish.expiration_manager`: Manages node expiration
  processing
- `commerce_pay_publish.install_helper`: Handles module installation tasks

### Fields Created
The module automatically creates these fields on enabled content types:
- `field_publish_product`: Reference to the selected product
- `field_associated_order`: Reference to the payment order
- `field_publish_expiry`: Timestamp for when content expires

### Hooks Implemented
- `hook_install()`: Creates product types and fields
- `hook_node_presave()`: Unpublishes nodes by default
- `hook_form_node_form_alter()`: Adds payment selection to node forms
- `hook_commerce_order_update()`: Handles payment completion
- `hook_cron()`: Processes expired nodes
- `hook_mail()`: Sends notification emails
- `hook_preprocess_node()`: Adds relist button to unpublished nodes

## Requirements

- Drupal 8/9/10/11
- Commerce Core
- Commerce Product
- Commerce Order
- Commerce Checkout

## Support

This is a custom module. For support, please contact the development team.
