<?php

namespace Drupal\commerce_pay_publish\EventSubscriber;

use Drupal\commerce_cart\Event\CartEntityAddEvent;
use Drupal\commerce_cart\Event\CartEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Provides event listeners for the cart entity add event.
 */
class AddToCartFormAlterSubscriber implements EventSubscriberInterface {

  /**
   * Get the subscribed events.
   */
  public static function getSubscribedEvents() {
    return [
      CartEvents::CART_ENTITY_ADD => 'onAddToCart',
    ];
  }

  /**
   * Alter the cart entity add form.
   */
  public function onAddToCart(CartEntityAddEvent $event) {
    $order_item = $event->getOrderItem();
    $request = \Drupal::requestStack()->getCurrentRequest();
    $nid = $request->get('nid');
    if ($nid && $order_item->hasField('field_source_nid')) {
      $order_item->set('field_source_nid', $nid);
      $order_item->save();
    }
  }

}
