<?php

declare(strict_types=1);

namespace Drupal\commerce_pay_publish\Entity;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Provides an interface for Commerce Pay Publish entities.
 */
interface PayPublishPlanUsageInterface extends ContentEntityInterface {

  /**
   * Gets the ID of the entity or object.
   *
   * @return int|null
   *   The ID of the entity or object, or NULL if not set.
   */
  public function getId(): ?int;

  /**
   * Sets the ID for the entity or object.
   *
   * @param int $id
   *   The ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setId(int $id): self;

  /**
   * Gets the plan ID.
   *
   * @return int|null
   *   The plan ID of the entity or object, or NULL if not set.
   */
  public function getPlanId(): ?int;

  /**
   * Sets the plan ID for the entity or object.
   *
   * @param int $plan_id
   *   The plan ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setPlanId(int $plan_id): self;

  /**
   * Gets the node ID.
   *
   * @return int|null
   *   The node ID associated with this usage, or NULL if not set.
   */
  public function getNid(): ?int;

  /**
   * Sets the node ID for the entity or object.
   *
   * @param int $nid
   *   The node ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setNid(int $nid): self;

  /**
   * Gets the publish date.
   *
   * @return int|null
   *   The timestamp of when the node was published, or NULL if not set.
   */
  public function getPublishDate(): ?int;

  /**
   * Sets the publish date for the entity or object.
   *
   * @param int $timestamp
   *   The timestamp to set for the publish date.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setPublishDate(int $timestamp): self;

  /**
   * Gets the expiration date.
   *
   * @return int|null
   *   The timestamp of when the plan usage expires, or NULL if not set.
   */
  public function getExpiryDate(): ?int;

  /**
   * Sets the expiration date for the entity or object.
   *
   * @param int $timestamp
   *   The timestamp to set for the expiry date.
   */
  public function setExpiryDate(int $timestamp): self;

  /**
   * Active status of the plan usage.
   *
   * @return bool
   *   TRUE if the plan usage is active, FALSE otherwise.
   */
  public function isActive(): bool;

  /**
   * Sets the active status of the plan usage.
   *
   * @param bool $status
   *   The status to set for the plan usage.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setStatus(bool $status): self;

  /**
   * Gets the user ID.
   *
   * @return int|null
   *   The user ID associated with this usage, or NULL if not set.
   */
  public function getUserId(): ?int;

  /**
   * Sets the user ID for the entity or object.
   *
   * @param int $user_id
   *   The user ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setUserId(int $user_id): self;

  /**
   * Gets the version ID.
   *
   * @return int|null
   *   The version ID associated with this usage, or NULL if not set.
   */
  public function getVersionId(): ?int;

  /**
   * Sets the version ID for the entity or object.
   *
   * @param int $version_id
   *   The version ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setVersionId(int $version_id): self;

}
