<?php

declare(strict_types=1);

namespace Drupal\commerce_pay_publish\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the PayPublishPurchasedPlan entity.
 *
 * @ContentEntityType(
 *   id = "commerce_pay_publish_plan",
 *   label = @Translation("Pay Publish Plan"),
 *   base_table = "commerce_pay_publish_plan",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid"
 *   },
 * )
 */
class PayPublishPlan extends ContentEntityBase implements PayPublishPlanInterface {

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('ID'))
      ->setReadOnly(TRUE);

    $fields['order_id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Order ID'));

    $fields['order_item_id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Order Item ID'));

    $fields['product_id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Product ID'));

    $fields['uid'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('User ID'));

    $fields['purchased_date'] = BaseFieldDefinition::create('timestamp')
      ->setLabel(t('Purchased Date'));

    $fields['expiry_date'] = BaseFieldDefinition::create('timestamp')
      ->setLabel(t('Expiry Date'));

    $fields['publish_limit'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Publish Limit'));

    $fields['used_nodes'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Used Nodes'));

    $fields['order_item_quantity'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Order Item Quantity'));

    $fields['status'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('Status'));

    return $fields;
  }

  /**
   * {@inheritdoc}
   */
  public function getId(): ?int {
    return $this->get('id')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setId(int $id): self {
    $this->set('id', $id);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getOrderId(): ?int {
    return $this->get('order_id')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setOrderId(int $order_id): self {
    $this->set('order_id', $order_id);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getOrderItemId(): ?int {
    return $this->get('order_item_id')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setOrderItemId(int $order_item_id): self {
    $this->set('order_item_id', $order_item_id);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getProductId(): ?int {
    return $this->get('product_id')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setProductId(int $product_id): self {
    $this->set('product_id', $product_id);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getUid(): ?int {
    return $this->get('uid')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setUid(int $uid): self {
    $this->set('uid', $uid);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getPurchasedDate(): ?int {
    return $this->get('purchased_date')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setPurchasedDate(int $timestamp): self {
    $this->set('purchased_date', $timestamp);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getExpiryDate(): ?int {
    return $this->get('expiry_date')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setExpiryDate(int $timestamp): self {
    $this->set('expiry_date', $timestamp);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getPublishLimit(): ?int {
    return (int) $this->get('publish_limit')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setPublishLimit(int $limit): self {
    $this->set('publish_limit', $limit);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getUsedNodes(): ?int {
    return (int) $this->get('used_nodes')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function addUsedNodes(): self {
    $used_nodes = $this->getUsedNodes() + 1;
    $publish_limit = $this->getPublishLimit();
    if ($used_nodes >= $publish_limit) {
      $this->setStatus(FALSE);
    }
    $this->set('used_nodes', $used_nodes);

    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function isActive(): bool {
    return (bool) $this->get('status')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setStatus(bool $status): self {
    $this->set('status', $status);
    return $this;
  }

}
