<?php

declare(strict_types=1);

namespace Drupal\commerce_pay_publish\Entity;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Defines the interface for PayPublishPlanUsage entities.
 */
interface PayPublishPlanInterface extends ContentEntityInterface {

  /**
   * Gets the ID of the entity or object.
   *
   * @return int|null
   *   The ID of the entity or object, or NULL if not set.
   */
  public function getId(): ?int;

  /**
   * Sets the ID for the entity or object.
   *
   * @param int $id
   *   The ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setId(int $id): self;

  /**
   * Gets the order ID associated with this plan.
   *
   * @return string|null
   *   The name of the entity or object, or NULL if not set.
   */
  public function getOrderId(): ?int;

  /**
   * Sets the name for the entity or object.
   *
   * @param int $order_id
   *   The order ID to set.
   */
  public function setOrderId(int $order_id): self;

  /**
   * Gets the order item ID associated with this plan.
   *
   * @return int|null
   *   The order item ID of the entity or object, or NULL if not set.
   */
  public function getOrderItemId(): ?int;

  /**
   * Sets the order item ID for the entity or object.
   *
   * @param int $order_item_id
   *   The order item ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setOrderItemId(int $order_item_id): self;

  /**
   * Gets the product ID associated with this plan.
   *
   * @return int|null
   *   The product ID of the entity or object, or NULL if not set.
   */
  public function getProductId(): ?int;

  /**
   * Sets the product ID for the entity or object.
   *
   * @param int $product_id
   *   The product ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setProductId(int $product_id): self;

  /**
   * Gets the user ID associated with this plan.
   *
   * @return int|null
   *   The user ID of the entity or object, or NULL if not set.
   */
  public function getUid(): ?int;

  /**
   * Sets the user ID for the entity or object.
   *
   * @param int $uid
   *   The user ID to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setUid(int $uid): self;

  /**
   * Gets the date when the plan was purchased.
   *
   * @return int|null
   *   The timestamp of when the plan was purchased, or NULL if not set.
   */
  public function getPurchasedDate(): ?int;

  /**
   * Sets the date when the plan was purchased.
   *
   * @param int $timestamp
   *   The timestamp to set for the purchased date.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setPurchasedDate(int $timestamp): self;

  /**
   * Gets the date when the plan expires.
   *
   * @return int|null
   *   The timestamp of when the plan expires, or NULL if not set.
   */
  public function getExpiryDate(): ?int;

  /**
   * Sets the date when the plan expires.
   *
   * @param int $timestamp
   *   The timestamp to set for the expiry date.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setExpiryDate(int $timestamp): self;

  /**
   * Gets the publish limit for the plan.
   *
   * @return int|null
   *   The publish limit of the plan, or NULL if not set.
   */
  public function getPublishLimit(): ?int;

  /**
   * Sets the publish limit for the plan.
   *
   * @param int $limit
   *   The publish limit to set.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setPublishLimit(int $limit): self;

  /**
   * Gets the publish limit per month for the plan.
   *
   * @return int|null
   *   The publish limit per month of the plan, or NULL if not set.
   */
  public function getUsedNodes(): ?int;

  /**
   * Increments the used nodes count.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function addUsedNodes(): self;

  /**
   * Checks if the plan is active.
   *
   * @return bool
   *   TRUE if the plan is active, FALSE otherwise.
   */
  public function isActive(): bool;

  /**
   * Sets the status of the plan.
   *
   * @param bool $status
   *   The status to set for the plan.
   *
   * @return self
   *   Returns the current instance for chaining.
   */
  public function setStatus(bool $status): self;

}
