<?php

declare(strict_types=1);

namespace Drupal\commerce_pay_publish\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the PayPublishPlanUsage entity.
 *
 * @ContentEntityType(
 *   id = "commerce_pay_publish_plan_usage",
 *   label = @Translation("Pay Publish Plan Usage"),
 *   base_table = "commerce_pay_publish_plan_usage",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid"
 *   },
 * )
 */
class PayPublishPlanUsage extends ContentEntityBase implements PayPublishPlanUsageInterface {

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('ID'))
      ->setReadOnly(TRUE);

    $fields['plan_id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Plan ID'));

    $fields['nid'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Node ID'));

    $fields['vid'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Version ID'));

    $fields['user_id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('User ID'));

    $fields['publish_date'] = BaseFieldDefinition::create('timestamp')
      ->setLabel(t('Publish Date'));

    $fields['expiry_date'] = BaseFieldDefinition::create('timestamp')
      ->setLabel(t('Expiry Date'));

    $fields['status'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('Status'));

    return $fields;
  }

  /**
   * {@inheritdoc}
   */
  public function getId(): ?int {
    return $this->get('id')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setId(int $id): self {
    $this->set('id', $id);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getPlanId(): ?int {
    $value = $this->get('plan_id')->value;
    return $value !== NULL ? (int) $value : NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function setPlanId(int $plan_id): self {
    $this->set('plan_id', $plan_id);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getNid(): ?int {
    return $this->get('nid')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setNid(int $nid): self {
    $this->set('nid', $nid);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getPublishDate(): ?int {
    return $this->get('publish_date')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setPublishDate(int $timestamp): self {
    $this->set('publish_date', $timestamp);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getExpiryDate(): ?int {
    return $this->get('expiry_date')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setExpiryDate(int $timestamp): self {
    $this->set('expiry_date', $timestamp);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function isActive(): bool {
    return (bool) $this->get('status')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setStatus(bool $status): self {
    $this->set('status', $status);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getUserId(): ?int {
    return $this->get('user_id')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setUserId(int $user_id): self {
    $this->set('user_id', $user_id);
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getVersionId(): ?int {
    return $this->get('vid')->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setVersionId(int $version_id): self {
    $this->set('vid', $version_id);
    return $this;
  }

}
