<?php

declare(strict_types=1);

namespace Drupal\commerce_pay_publish\ProductBundle;

use Drupal\commerce_product\Entity\Product;

/**
 * Bundle class for Product type "pay_publish".
 *
 * Provides easy access to product fields specific to pay_publish product type.
 */
class PayPublishProductBundle extends Product implements PayPublishProductBundleInterface {

  /**
   * Gets the bundle limit value.
   *
   * @return int|null
   *   The bundle limit value, or NULL if not set.
   */
  public function getBundleLimit(): ?int {
    return $this->get(PayPublishProductBundleInterface::BUNDLE_LIMIT)->isEmpty()
      ? NULL
      : (int) $this->get(PayPublishProductBundleInterface::BUNDLE_LIMIT)->value;
  }

  /**
   * Gets the expiration duration value.
   *
   * @return array|null
   *   The expiration duration as an array with 'interval' and 'period' keys,
   *   or NULL if not set.
   */
  public function getExpirationDuration(): ?array {
    if ($this->get(PayPublishProductBundleInterface::EXPIRATION_DURATION)->isEmpty()) {
      return NULL;
    }

    $duration = $this->get(PayPublishProductBundleInterface::EXPIRATION_DURATION)->first();
    return [
      'interval' => (int) $duration->interval,
      'period' => $duration->period,
    ];
  }

  /**
   * Gets the product expire value.
   *
   * @return array|null
   *   The product expire duration as an array with 'interval' and 'period' keys,
   *   or NULL if not set.
   */
  public function getProductExpire(): ?array {
    if ($this->get(PayPublishProductBundleInterface::PRODUCT_EXPIRE)->isEmpty()) {
      return NULL;
    }

    $expire = $this->get(PayPublishProductBundleInterface::PRODUCT_EXPIRE)->first();
    return [
      'interval' => (int) $expire->interval,
      'period' => $expire->period,
    ];
  }

}
