<?php

declare(strict_types=1);

namespace Drupal\commerce_pay_publish\ProductBundle;

/**
 * Interface for the PayPublishProductBundle class.
 */
interface PayPublishProductBundleInterface {

  const BUNDLE_LIMIT = 'field_bundle_limit';
  const EXPIRATION_DURATION = 'field_expiration_duration';
  const PRODUCT_EXPIRE = 'field_product_expire';

  /**
   * Gets the bundle limit value.
   *
   * @return int|null
   *   The bundle limit value, or NULL if not set.
   */
  public function getBundleLimit(): ?int;

  /**
   * Gets the expiration duration value.
   *
   * @return array|null
   *   The expiration duration as an array with 'interval' and 'period' keys,
   *   or NULL if not set.
   */
  public function getExpirationDuration(): ?array;

  /**
   * Gets the product expire value.
   *
   * @return array|null
   *   The product expire duration as an array with 'interval' and 'period' keys,
   *   or NULL if not set.
   */
  public function getProductExpire(): ?array;

}
